% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drop_upload.R
\name{drop_upload}
\alias{drop_upload}
\title{Uploads a file to Dropbox using PUT semantics.}
\usage{
drop_upload(file, dest = NULL, overwrite = TRUE, autorename = FALSE,
  verbose = FALSE, encode = "multipart", dtoken = get_dropbox_token())
}
\arguments{
\item{file}{Relative path to local file.}

\item{dest}{The relative path on Dropbox where the file should get uploaded.}

\item{overwrite}{Default behavior (\code{TRUE}) is to overwrite files in the
destination. Set to \code{FALSE} to prevent this.}

\item{autorename}{This value, either true (default) or false, determines what
happens when there is a conflict. If true, the file being uploaded will be
automatically renamed to avoid the conflict. (For example, test.txt might be
automatically renamed to test (1).txt.) The new name can be obtained from
the returned metadata. If false, the call will fail with a 409 (Conflict).
response code.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}

\item{encode}{The file encoding}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
This function will allow you to write files of any size to Dropbox(even ones
that cannot be read into memory) by uploading them in chunks.
}
\examples{
\dontrun{
write.csv(mtcars, file = "mtt.csv")
drop_upload("mtt.csv")
}
}

