% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_url.r
\name{dryad_files}
\alias{dryad_files}
\title{Get a URL given a Dryad DOI}
\usage{
dryad_files(doi, ...)
}
\arguments{
\item{doi}{(character) A Dryad dataset DOI, of the form
10.5061/dryad.xxx. required}

\item{...}{Curl options, passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
(character) One or more URLS for direct download of datasets
for the given Dryad DOI
}
\description{
To get a DOI from a Dryad Handle, use \code{\link[=handle2doi]{handle2doi()}}
}
\examples{
\dontrun{
dryad_files(doi = '10.5061/dryad.1758')
dryad_files(doi = '10.5061/dryad.60699')

# if you have a handle, use handle2doi() to convert to a DOI
(doi <- handle2doi('10255/dryad.153920'))
(files <- dryad_files(doi))
(out <- dryad_fetch(files))
# file sizes in MB
vapply(out, function(x) file.info(x)[["size"]], 1) / 10^6
}
}
