% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createIndex.R
\name{createIndex}
\alias{createIndex}
\title{Create file and meta index of the DWD CDC FTP Server}
\usage{
createIndex(
  paths,
  base = dwdbase,
  dir = "DWDdata",
  fname = "fileIndex.txt",
  meta = FALSE,
  metadir = "meta",
  mname = "metaIndex.txt",
  gname = "geoIndex.txt",
  overwrite = FALSE,
  checkwarn = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{paths}{Char: vector of DWD paths returned by \code{\link{indexFTP}} called
with the same \code{base} value as this function}

\item{base}{Main directory of DWD ftp server, defaulting to observed climatic records.
DEFAULT: \code{\link{dwdbase}}}

\item{dir}{Char: writeable directory name where to save the main output(s).
Created if not existent. DEFAULT: "DWDdata" at current \code{\link{getwd}()}}

\item{fname}{Char: Name of file in \code{dir} in which to write \code{\link{fileIndex}}.
Use \code{fname=""} to suppress writing. DEFAULT: "fileIndex.txt"}

\item{meta}{Logical: should metaIndex also be created from fileIndex?
Uses \code{\link{dataDWD}} to download files if not present.
DEFAULT: FALSE}

\item{metadir}{Char: Directory (subfolder of \code{dir}) where original
description files are downloaded to if meta=TRUE. Passed to
\code{\link{dataDWD}}. "" to write in \code{dir}. DEFAULT: "meta"}

\item{mname}{Char: Name of file in \code{dir} (not \code{metadir}) in which to
write \code{\link{metaIndex}}.
Use \code{mname=""} to suppress writing. DEFAULT: "metaIndex.txt"}

\item{gname}{Filename for \code{\link{geoIndex}}. DEFAULT: "geoIndex.txt"}

\item{overwrite}{Logical: Overwrite existing \code{fname / mname / gname} files? 
If not, "_n" is added to the filenames, see 
\code{berryFunctions::\link[berryFunctions]{newFilename}}.
DEFAULT: FALSE}

\item{checkwarn}{Logical: warn about \code{\link{checkIndex}} issues? DEFAULT: TRUE}

\item{quiet}{Logical: Suppress messages about progress and filenames? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{dataDWD}} for the meta part.}
}
\value{
invisible data.frame (or if meta=TRUE, list with two data.frames)
with a number of columns inferred from the paths. Each is also written to disc.
}
\description{
This is mainly an internal function.
Create data.frames out of the vector index returned by \code{\link{indexFTP}}.
For \code{\link{fileIndex}} (the first output element) \code{createIndex}
tries to obtain res, var, per, file, id, start and end from the paths.
If \code{meta=TRUE}, \code{\link{metaIndex}} and \code{\link{geoIndex}} are also
created. They combine all Beschreibung files into a single data.frame.\cr
If you create your own index as suggested in selectDWD (argument \code{findex}),
you can read the produced file as shown in the example section.
}
\examples{
\dontrun{ # Not tested with R CMD check because of file writing
link <- "daily/kl/historical/tageswerte_00699_19490101_19580630_hist.zip"
ind <- createIndex(link, dir=tempdir())
ind
link2 <- "daily/kl/historical/KL_Tageswerte_Beschreibung_Stationen.txt"
link3 <- "daily/kl/recent/KL_Tageswerte_Beschreibung_Stationen.txt"
ind2 <- createIndex(c(link,link2,link3), dir=tempdir(), meta=TRUE)
lapply(ind2, head)
}

}
\seealso{
\code{\link{indexFTP}}, \code{\link{updateIndexes}}
\code{\link{index}}, \code{\link{selectDWD}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct-Nov 2016, June 2017
}
\keyword{manip}
