% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.grib2}
\alias{readDWD.grib2}
\title{read nwp forecast data}
\usage{
readDWD.grib2(file, pack = "terra", bargs = NULL, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
cosmo-d2_germany_regular-lat-lon_single-level_2021010100_005_T_2M.grib2.bz2}

\item{pack}{Char: package used for reading.
One of "terra" or "stars".
"rgdal" (for the deprecated cosmo-d2 data) is no longer available,
see \href{https://github.com/brry/rdwd/issues/28}{issue}.
DEFAULT: "terra"}

\item{bargs}{Named list of arguments passed to
\code{\link[R.utils:compressFile]{R.utils::bunzip2()}}, see \code{gargs} in \code{\link[=readDWD.raster]{readDWD.raster()}}. DEFAULT: NULL}

\item{quiet}{Silence readGDAL completely, including warnings on
discarded ellps / datum.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[terra:rast]{terra::rast()}} or
\code{\link[stars:read_stars]{stars::read_stars()}}.}
}
\value{
terra or stars object, depending on \code{pack}
}
\description{
read gridded numerical weather prediction data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests
nwp_t2m_base <- "ftp://opendata.dwd.de/weather/nwp/icon-d2/grib/15/soiltyp"
nwp_urls <- indexFTP("", base=nwp_t2m_base, dir=tempdir())
# for p instead of soiltyp, icosahedral_model-level files fail with GDAL errors,
# see https://github.com/brry/rdwd/issues/28
# regular-lat-lon_pressure-level files work with pack="terra" or "stars"

nwp_file <- dataDWD(tail(nwp_urls,1), base=nwp_t2m_base, dir=tempdir(), 
                    joinbf=TRUE, dbin=TRUE, read=FALSE)
nwp_data <- readDWD(nwp_file)
terra::plot(nwp_data)
addBorders() # the projection seems to be perfectly good :)

# index of GRIB files
if(FALSE){ # indexing takes about 6 minutes!
grib_base <- "ftp://opendata.dwd.de/weather/nwp/icon-d2/grib"
grib_files <- indexFTP("", base=grib_base, dir=tempdir())
for(f in unique(substr(grib_files, 1,3))) print(grib_files[which(substr(grib_files, 1,3)==f)[1]])
View(data.frame(grep("regular",grib_files, value=TRUE)))
}
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}\cr
\url{https://www.dwd.de/EN/ourservices/nwp_forecast_data/nwp_forecast_data.html}\cr
\url{https://www.dwd.de/EN/aboutus/it/functions/Teasergroup/grib.html}\cr
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2021.
}
