% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{re2_count}
\alias{re2_count}
\title{Count the number of matches in a string.}
\usage{
re2_count(string, pattern, anchor = UNANCHORED, parallel = FALSE,
  grain_size = 1e+05, ...)
}
\arguments{
\item{string}{a character vector}

\item{pattern}{a character vector or pre-compiled regular expressions}

\item{anchor}{see \code{\link{UNANCHORED}}}

\item{parallel}{use multithread}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
An integer vector.
}
\description{
Count the number of matches in a string. Vectorised over strings and patterns.
}
\examples{
re2_count("one", "(o.e)")
re2_count("123-234-2222", "\\\\d\\\\d\\\\d-\\\\d\\\\d\\\\d-\\\\d\\\\d\\\\d\\\\d")

words = c("sunny","beach","happy","really")
re2_count(words, "y")
re2_count(words, "^b")
re2_count(words, "[abc]")

# vectorize
re2_count("This", letters)
}
