% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widget.R
\name{show_regex}
\alias{show_regex}
\title{Show regex pattern in a htmlwidget}
\usage{
show_regex(pattern, width = NULL, height = NULL)
}
\arguments{
\item{pattern}{a pattern string}

\item{width}{the widget width}

\item{height}{the widget height}
}
\description{
Show JS-style regex pattern in an htmlwidget.
}
\details{
Most parts of RE2 regex syntax are supported, except for some special Unicode character classes.
}
\examples{
# Skip on CRAN

\dontrun{

# US ZIP code

show_regex("[0-9]{5}(?:-[0-9]{4})?")

# Email

show_regex("\\\\b[a-zA-Z0-9._\%-]+@[a-zA-Z0-9.-]+\\\\.[a-zA-Z]{2,4}\\\\b")

# Hex value

show_regex("#?([a-f0-9]{6}|[a-f0-9]{3})")

}

}
\seealso{
https://regexper.com/documentation.html
}
