% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCSM}
\alias{plotCSM}
\title{Produce Cumulative Sample Mean Function Plots}
\usage{
plotCSM(formula, data, onePanel = FALSE, adjrisk = TRUE,
  smooth = FALSE, control = list(), ...)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a "~" operator, and the predictors on the right.
The response must be a recurrent event survival object returned by the \code{Recur()} function.}

\item{data}{an optional data frame in which to interpret the variables occurring in the "\code{formula}".}

\item{onePanel}{an optional logical value indicating whether the cumulative sample means (CSM) will be plotted in the same panel.
This is only useful when there are multiple recurrent event types or in the presence of (discrete) covariates.}

\item{adjrisk}{an optional logical value indicating whether risk set will be adjusted,
e.g., if \code{TRUE}, subjects leave the risk set after terminal times. See \bold{Details}.}

\item{smooth}{an optional logical value indicating whether to add a smooth curve obtained from a monotone increasing P-splines implemented in package \code{scam}.
This feature only works for data with one recurrent event type.}

\item{control}{a list of control parameters.}

\item{...}{graphical parameters to be passed to methods.
These include \code{xlab}, \code{ylab}, \code{main}, and more. See \bold{Details}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the cumulative sample mean function (CSM) for an \code{Recur} object.
The usage of the function is similar to that of \code{plot.Recur} but with more flexible options.
}
\details{
When \code{adjrisk = TRUE}, the \code{plotCSM} is equivalent to
the Nelson-Aalen estimator for the intensity function of the recurrent event process.
When \code{adjrisk = FALSE}, the \code{plotCSM} does not adjust for the risk set and
assumes all subjects remain at risk after the last observed recurrent event.
This is known as the survivor rate function.
The argument \code{control} consists of options with argument defaults
to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Cumulative mean".}
  \item{main}{customizable title, default value is "Sample cumulative mean function plot".}
}
The \code{xlab}, \code{ylab} and \code{main} parameters can also be passed down without specifying a \code{control} list.
}
\examples{
set.seed(1)
dat <- simSC(30, c(-1, 1), c(-1, 1))
plotCSM(Recur(Time, id, event, status) ~ 1, data = dat)
plotCSM(Recur(Time, id, event, status) ~ x1, data = dat)
plotCSM(Recur(Time, id, event, status) ~ x1, data = dat, onePanel = TRUE)


}
\seealso{
\code{\link{Recur}}, \code{\link{plot.Recur}}
}
\keyword{Plots}
