% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{default}
\alias{default}
\title{Theme default}
\usage{
default(
  font_family = "-apple-system,BlinkMacSystemFont,Helvetica,Arial,sans-serif",
  font_size = 15,
  font_color = "#333333",
  header_font_family = "-apple-system,BlinkMacSystemFont,Helvetica,Arial,sans-serif",
  header_font_size = 15,
  header_font_color = "#333333",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is -apple-system, BlinkMacSystemFont, Helvetica, Arial, sans-serif.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #333333.}

\item{header_font_family}{Font family for the header text.
Default is -apple-system, BlinkMacSystemFont, Helvetica, Arial, sans-serif.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #333333.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Reactable-inspired default theme
}
\examples{
data <- iris[10:29, ]

## Standard default theme
reactable(data,
          theme = default())

## Default theme with additional options applied
reactable(data,
          theme = default(font_size = 12, font_color = "grey", cell_padding = 3))

}
