% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbc2dbf.R
\name{dbc2dbf}
\alias{dbc2dbf}
\title{Decompress a DBC file}
\source{
The internal C code for \code{dbc2dbf} is based on \code{blast} decompressor and \code{blast-dbf} (see \emph{References}).
}
\usage{
dbc2dbf(input.file, output.file)
}
\arguments{
\item{input.file}{The name of the DBC file (including extension)}

\item{output.file}{The output file name (including extension)}
}
\value{
Return TRUE if succeed, FALSE otherwise.
}
\description{
This function allows you decompress a DBC file. When decompressed, it becomes a regular DBF file.
}
\details{
DBC is the extension for compressed DBF files (from the 'XBASE' family of databases).
This is a proprietary file format used by the Brazilian government to publish public healthcare data.
When decompressed, it becomes a regular DBF file.

Please note that this is the file format is not related to the FoxPro or CANdb DBC file formats.
}
\examples{
# Input file name
input  <- system.file("files/sids.dbc", package = "read.dbc")

# Output file name
output <- tempfile(fileext = ".dbf")

# The call returns TRUE on success
if( dbc2dbf(input.file = input, output.file = output) ) {
     print("File decompressed!")
     # do things with the file
}

file.remove(output) # clean up example, don't do in real life :)

}
\references{
\code{blast} source code in C: \url{https://github.com/madler/zlib/tree/master/contrib/blast}
\code{blast-dbf}, DBC to DBF command-line decompression tool: \url{https://github.com/eaglebh/blast-dbf}
}
\seealso{
\code{\link{read.dbc}}
}
\author{
Daniela Petruzalek, \email{daniela.petruzalek@gmail.com}
}
\keyword{dbc}
\keyword{dbf}
