% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{parse_factor}
\alias{parse_factor}
\alias{col_factor}
\title{Parse factors}
\usage{
parse_factor(
  x,
  levels = NULL,
  ordered = FALSE,
  na = c("", "NA"),
  locale = default_locale(),
  include_na = TRUE,
  trim_ws = TRUE
)

col_factor(levels = NULL, ordered = FALSE, include_na = FALSE)
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{levels}{Character vector of the allowed levels. When \code{levels = NULL}
(the default), \code{levels} are discovered from the unique values of \code{x}, in
the order in which they appear in \code{x}.}

\item{ordered}{Is it an ordered factor?}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{include_na}{If \code{TRUE} and \code{x} contains at least one \code{NA}, then \code{NA}
is included in the levels of the constructed factor.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}
}
\description{
\code{parse_factor()} is similar to \code{\link[=factor]{factor()}}, but generates a warning if
\code{levels} have been specified and some elements of \code{x} are not found in those
\code{levels}.
}
\examples{
# discover the levels from the data
parse_factor(c("a", "b"))
parse_factor(c("a", "b", "-99"))
parse_factor(c("a", "b", "-99"), na = c("", "NA", "-99"))
parse_factor(c("a", "b", "-99"), na = c("", "NA", "-99"), include_na = FALSE)

# provide the levels explicitly
parse_factor(c("a", "b"), levels = letters[1:5])

x <- c("cat", "dog", "caw")
animals <- c("cat", "dog", "cow")

# base::factor() silently converts elements that do not match any levels to
# NA
factor(x, levels = animals)

# parse_factor() generates same factor as base::factor() but throws a warning
# and reports problems
parse_factor(x, levels = animals)
}
\seealso{
Other parsers: 
\code{\link{col_skip}()},
\code{\link{cols}()},
\code{\link{cols_condense}()},
\code{\link{parse_datetime}()},
\code{\link{parse_guess}()},
\code{\link{parse_logical}()},
\code{\link{parse_number}()},
\code{\link{parse_vector}()}
}
\concept{parsers}
