% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{plot_data}
\alias{plot_data}
\title{Create spatial pixels data frame}
\usage{
plot_data(
  lg,
  covariates,
  per.days = 10000,
  change.lag = NULL,
  relative = TRUE,
  msq = 10000,
  rr_lim = NULL
)
}
\arguments{
\item{lg}{An lgcpReal object, output from a call to \code{lgcp}}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest and containing
the covariate and population density data. Typically the same object as specified in the
\code{covariates} argument in the call to \code{lgcp}.}

\item{per.days}{Integer, the number of person-days to use for incidence, default is 10,000.}

\item{change.lag}{If not NULL, then plots are created of the change in outputs compared to
this number of periods prior.}

\item{relative}{A logical value indicating whether the comparisons (if change.lag set) should be relative (default),
i.e. incidence rate ratios and ratios of relative risks, or absolute.}

\item{msq}{Integer, the denominator of the population density, default is hectares (population per
10,000m^2)}

\item{rr_lim}{Integer, for plotting the relative risk, the maximum value of the colour scale. Useful
when comparing multiple plots to put colour gradient on same scale.}
}
\value{
A code{spatialPolygonsDataFrame}
}
\description{
Output spatial pixels data frame of lgcp predictions
}
\details{
This function generates a spatial pixels data frame with the output
from lgcp.
}
\examples{
\donttest{
data(dat,square,square_pop)
lg1 <- lgcp(data=dat,
            pop.var = c("popdens"),
            boundary=square,
            covariates=square_pop,
            cellwidth=0.1,
            laglength = 7,
            mala.pars=c(200,100,1),
            nchains=2)
plot_data(lg1,square_pop)
}
}
\seealso{
aggregator_data, plot_hotspot
}
