% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{plot_hotspot_data}
\alias{plot_hotspot_data}
\title{Produce hotspot spatial pixels data}
\usage{
plot_hotspot_data(
  lg,
  covariates,
  threshold.var = NULL,
  threshold.value = NULL,
  labels,
  threshold.prob = 0.8,
  relative = TRUE,
  per.days = 10000,
  msq = 10000
)
}
\arguments{
\item{lg}{Output from a call to \code{lgcp}}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest and containing
the covariate and population density data. Typically the same object as specified in the
\code{covariates} argument in the call to \code{lgcp}.}

\item{threshold.var}{A vector of one or two strings specifying the variables to define the hotspots,
see Details for how to specify.}

\item{threshold.value}{A vector or one or two values indicating the threshold(s) for determining
a hotspot. Given in the same order as threshold.var.}

\item{labels}{A vector of two or four labels for the hotspots, see Details.}

\item{threshold.prob}{A vector of one or two values specifying the exceedence probabilities.}

\item{relative}{A logical value. If one or both of the variable is with respect to a previous time period, whether the comparison
should be relative (TRUE) or absolute (FALSE)}

\item{per.days}{If one or both of the variables is incidence, the denominator number of person-days.}

\item{msq}{The denominator for the population density in m^2. Default is hectares (per 10,000m^2)}
}
\value{
A \code{spatialPixelsDataFrame}
}
\description{
Generate a spatial pixels data frame classifying hotspots and probabilities
}
\examples{
\donttest{
data(dat,square,square_pop)
lg1 <- lgcp(data=dat,
            pop.var = c("popdens"),
            boundary=square,
            covariates=square_pop,
            cellwidth=0.1,
            laglength = 7,
            mala.pars=c(200,100,1),
            nchains=2)
plot_hotspot_data(lg1,
             covariates = square_pop,
             threshold.var = c("poppp+obs+latent"),
             threshold.value = 1,
             threshold.prob=0.8,
             labels=c('low','high incidence'))
}
}
