% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorts.R
\name{cohort_fn}
\alias{cohort_fn}
\title{Compares proportions of matching summary statistics in different cohorts}
\usage{
cohort_fn(
  df = cohort_data,
  seed = 0,
  sims = -1,
  n_vars = 10,
  popn = "",
  title = "",
  verbose = TRUE
)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{seed}{the seed to use for random number generation, default 0 = current date and time. Specify seed to make repeatable.}

\item{sims}{number of simulations, default -1 = function selects based on number of variables and sample size.}

\item{n_vars}{restrict analyses to variables in at least (>=) this number of cohorts, default = 10 (ie variable has mean in 10 or more cohorts).}

\item{popn}{if dataset contains studies in different sub-populations, code this in cohort_data$population and studies are subsetted if match in this variable. 'All' overrides this and uses all data regardless of information in this variable.}

\item{title}{title name for plots (optional)}

\item{verbose}{TRUE or FALSE indicates whether progress bar and comments show and flextable is printed}
}
\value{
list containing 6 objects as described
\itemize{
\item cohort_ft = flextable of results
\item cohort_graph = plot of observed to expected numbers of matches per cohort for mean; SD; and mean and SD
\item all_graphs = list containing
\itemize{
\item all_graphs = all plots on single plot
\item both_graphs = list of 3 plots row by row used to form all_graphs
\item individual_graphs= list of 6 individual plots used to form all_graphs
}
\item cohort_cohort_data = data frame used to generate results data
\item cohort_prob_data = data frame used to make flextable
\item cohort_oe_data= data frame used to make observed to expected plots
}
}
\description{
Creates flextable of probability of matching mean, SD, and mean and SD for each variable in different cohorts in the
specified number of simulations\cr
}
\details{
Reference data is from Bolland 2021\cr
Bolland MJ, Gamble GD, Avenell A, Grey A. Identical summary statistics were uncommon in randomized trials and cohort studies. J Clin Epidemiol 2021;136:180-188.

Returns a list containing 6 objects and (if verbose = TRUE) prints the flextable cohort_ft
}
\examples{
# load example data
cohort_data <- load_clean(import= "no", file.cont = "SI_cohort", cohort= "yes",
format.cont = "long")$cohort_data

\donttest{
# run function (takes close to 5 seconds)
cohort_fn(seed=10, sims = 100)$cohort_ft

# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                     mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
cohort_data <- load_clean(import= "yes", cohort = "yes", dir = path,
     file.name.cont = "reappraised_examples.xlsx", sheet.name.cont = "SI_cohort",
     range.name.cont = "A1:F101", format.cont = "long")$cohort_data}

}
