library(rearrr)
context("windowing")


test_that("fuzz testing ndist_windows_()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "index" = 1:9,
    "A" = sample(1:9),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'ndist_windows_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = ndist_windows_,
  #   args_values = list(
  #     "data" = list(df, c(1,2,3,4,5,6,7)),
  #     "num_windows" = list(3, 4, 10, 0, NA),
  #     "factor_name" = list(".window", NA, 2)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'ndist_windows_'                                                  ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing ndist_windows_(data = df, num_windows = 3, fa...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- ndist_windows_(data = df, num_windows = 3, factor_name = ".window")
  # Testing class
  expect_equal(
    class(output_19148),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(9, 8, 3, 5, 4, 7, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".window"]],
    structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(9L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing ndist_windows_(data = c(1, 2, 3, 4, 5, 6, 7),...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(ndist_windows_(data = c(1, 2, 3, 4, 5, 6, 7), num_windows = 3, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = NULL, num_windows = 3, ...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(ndist_windows_(data = NULL, num_windows = 3, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 4, fa...
  # Changed from baseline: num_windows = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- ndist_windows_(data = df, num_windows = 4, factor_name = ".window")
  # Testing class
  expect_equal(
    class(output_18304),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18304[["index"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_18304[["A"]],
    c(9, 8, 3, 5, 4, 7, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_18304[[".window"]],
    structure(c(1L, 1L, 2L, 2L, 3L, 3L, 4L, 4L, 4L), .Label = c("1",
      "2", "3", "4"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_18304),
    c("index", "A", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18304),
    c("integer", "integer", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18304),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18304),
    c(9L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18304)),
    character(0),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 10, f...
  # Changed from baseline: num_windows = 10
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = 10, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * 'num_windows' was greater than the number of rows in 'data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 0, fa...
  # Changed from baseline: num_windows = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = 0, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_windows': Element 1 is not >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = NA, f...
  # Changed from baseline: num_windows = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = NA, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_windows': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = NULL,...
  # Changed from baseline: num_windows = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = NULL, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_windows': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 3, fa...
  # Changed from baseline: factor_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = 3, factor_name = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 3, fa...
  # Changed from baseline: factor_name = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = 3, factor_name = 2), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing ndist_windows_(data = df, num_windows = 3, fa...
  # Changed from baseline: factor_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(ndist_windows_(data = df, num_windows = 3, factor_name = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'ndist_windows_'                                         ####
  #

})

test_that("fuzz testing greedy_windows_()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "index" = 1:9,
    "A" = sample(1:9),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'greedy_windows_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = greedy_windows_,
  #   args_values = list(
  #     "data" = list(df, c(1,2,3,4,5,6), NA),
  #     "window_size" = list(3, 4, 0, 10, NA),
  #     "factor_name" = list(".window", NA, 2)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'greedy_windows_'                                                 ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing greedy_windows_(data = df, window_size = 3, f...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- greedy_windows_(data = df, window_size = 3, factor_name = ".window")
  # Testing class
  expect_equal(
    class(output_19148),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(9, 8, 3, 5, 4, 7, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".window"]],
    structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(9L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing greedy_windows_(data = c(1, 2, 3, 4, 5, 6), w...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(greedy_windows_(data = c(1, 2, 3, 4, 5, 6), window_size = 3, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = NA, window_size = 3, f...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(greedy_windows_(data = NA, window_size = 3, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = NULL, window_size = 3,...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(greedy_windows_(data = NULL, window_size = 3, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 4, f...
  # Changed from baseline: window_size = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- greedy_windows_(data = df, window_size = 4, factor_name = ".window")
  # Testing class
  expect_equal(
    class(output_16417),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16417[["index"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_16417[["A"]],
    c(9, 8, 3, 5, 4, 7, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_16417[[".window"]],
    structure(c(1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  # Testing column names
  expect_equal(
    names(output_16417),
    c("index", "A", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16417),
    c("integer", "integer", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16417),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(9L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16417)),
    character(0),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 0, f...
  # Changed from baseline: window_size = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = 0, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': Element 1 is not >= 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 10, ...
  # Changed from baseline: window_size = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- greedy_windows_(data = df, window_size = 10, factor_name = ".window")
  # Testing class
  expect_equal(
    class(output_17365),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["index"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["A"]],
    c(9, 8, 3, 5, 4, 7, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".window"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = "1", class = "factor"))
  # Testing column names
  expect_equal(
    names(output_17365),
    c("index", "A", ".window"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "integer", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(9L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = NA, ...
  # Changed from baseline: window_size = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = NA, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = NULL...
  # Changed from baseline: window_size = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = NULL, factor_name = ".window"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'window_size': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 3, f...
  # Changed from baseline: factor_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = 3, factor_name = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 3, f...
  # Changed from baseline: factor_name = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = 3, factor_name = 2), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing greedy_windows_(data = df, window_size = 3, f...
  # Changed from baseline: factor_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(greedy_windows_(data = df, window_size = 3, factor_name = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'factor_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'greedy_windows_'                                        ####
  #


})
