% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ebirdloc.R
\name{ebirdloc}
\alias{ebirdloc}
\title{Recent observations at a locality}
\usage{
ebirdloc(locID, species = NULL, back = NULL, max = NULL, locale = NULL,
  provisional = FALSE, simple = TRUE, sleep = 0, ...)
}
\arguments{
\item{locID}{(required) Vector containing code(s) for up to 10 regions of interest;
here, values that are not hotspots are returned. Values that are not valid are ignored.}

\item{species}{Scientific name of the species of interest (not case
sensitive). Defaults to NULL, in which case sightings for all species are returned.
See eBird taxonomy for more information:
http://ebird.org/content/ebird/about/ebird-taxonomy}

\item{back}{Number of days back to look for observations (between
1 and 30, defaults to 14).}

\item{max}{Maximum number of result rows to return in this request
(between 1 and 10000, defaults to all)}

\item{locale}{Language/locale of response (when translations are available).
See http://java.sun.com/javase/6/docs/api/java/util/Locale.html
(defaults to en_US)}

\item{provisional}{Should flagged records that have not been reviewed
be included? (defaults to FALSE)}

\item{simple}{Logical. Whether to return a simple (TRUE, default) or detailed
(FALSE) set of results fields.}

\item{sleep}{Time (in seconds) before function sends API call (defaults to
zero.  Set to higher number if you are using this function in a loop with
many API calls).}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame containing the collected information:

"comName": species common name

"howMany": number of individuals observed, NA if only presence was noted

"lat": latitude of the location

"lng": longitude of the location

"locID": unique identifier for the location

"locName": location name

"locationPrivate": TRUE if location is not a birding hotspot

"obsDt": observation date formatted according to ISO 8601
   (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes are excluded
   if the observer did not report an observation time.

"obsReviewed": TRUE if observation has been reviewed, FALSE otherwise

"obsValid": TRUE if observation has been deemed valid by either the
   automatic filters or a regional viewer, FALSE otherwise

"sciName" species' scientific name

"subnational2Code": county code (returned if simple=FALSE)

"subnational2Name": county name (returned if simple=FALSE)

"subnational1Code": state/province ISO code (returned if simple=FALSE)

"subnational1Name": state/province name (returned if simple=FALSE)

"countryCode": country ISO code (returned if simple=FALSE)

"countryName": country name (returned if simple=FALSE)

"userDisplayName": first and last name of the observer (returned if simple=FALSE)

"firstName": observer's first name (returned if simple=FALSE)

"lastName": observer's last name (returned if simple=FALSE)

"subID": submission ID (returned if simple=FALSE)

"obsID": observation ID (returned if simple=FALSE)

"checklistID": checklist ID (returned if simple=FALSE)

"presenceNoted": 'true' if user marked presence but did not count the
  number of birds. 'false' otherwise (returned if simple=FALSE)
}
\description{
Returns the most recent sighting information reported in a given vector
of locations (including non-hotspots).
}
\examples{
\dontrun{
ebirdloc(locID = c('L99381','L99382'))
ebirdloc('L99381', 'Branta canadensis', provisional=TRUE)
}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
\references{
\url{http://ebird.org/}
}

