% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping-and-repetition.R
\name{repeated}
\alias{lazy}
\alias{one_or_more}
\alias{optional}
\alias{repeated}
\alias{zero_or_more}
\title{Repeat values}
\usage{
repeated(x, lo, hi, lazy = FALSE, char_class = NA)

optional(x, char_class = NA)

lazy(x)

zero_or_more(x, char_class = NA)

one_or_more(x, char_class = NA)
}
\arguments{
\item{x}{A character vector.}

\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{lazy}{A logical value.  Should repetition be matched lazily or
greedily?}

\item{char_class}{A logical value. Should \code{x} be wrapped in a character
class?  If \code{NA}, the function guesses whether that's a good idea.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match repeated values.
}
\examples{
# Can match constants or class values
repeated(GRAPH, 2, 5)
repeated(graph(), 2, 5)   # same

# Short cuts for special cases
optional(blank())         # same as repeated(blank(), 0, 1)
zero_or_more(hex_digit()) # same as repeated(hex_digit(), 0, Inf)
one_or_more(printable())  # same as repeated(printable(), 1, Inf)

# 'Lazy' matching (match smallest no. of chars)
repeated(cntrl(), 2, 5, lazy = TRUE)
lazy(one_or_more(cntrl()))

# Overriding character class wrapping
repeated(ANY_CHAR, 2, 5, char_class = FALSE)
}
\references{
\url{http://www.regular-expressions.info/repeat.html} and
\url{http://www.rexegg.com/regex-quantifiers.html}
}

