% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_at.R
\name{step_rename_at}
\alias{step_rename_at}
\title{Rename multiple columns using dplyr}
\usage{
step_rename_at(
  recipe,
  ...,
  fn,
  role = "predictor",
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("rename_at")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{fn}{A function \code{fun}, a quosure style lambda `~ fun(.)`` or a list of
either form (but containing only a single function, see \code{\link[dplyr:select_all]{dplyr::rename_at()}}).
\strong{Note that this argument must be named}.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{A vector of column names populated by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_rename_at} creates a \emph{specification} of a recipe step that will rename
the selected variables using a common function via \code{\link[dplyr:select_all]{dplyr::rename_at()}}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} which contains the columns being transformed is returned.
}

\examples{
library(dplyr)
recipe(~ ., data = iris) \%>\%
  step_rename_at(everything(), fn = ~ gsub(".", "_", ., fixed = TRUE)) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:10)
}
\seealso{
Other dplyr steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_mutate_at}()},
\code{\link{step_mutate}()},
\code{\link{step_rename}()},
\code{\link{step_sample}()},
\code{\link{step_select}()},
\code{\link{step_slice}()}
}
\concept{dplyr steps}
