% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_n_to_m.R
\name{match_n_to_m}
\alias{match_n_to_m}
\title{Force n to m matching on a set of pairs}
\usage{
match_n_to_m(x, y, w, n = 1, m = 1)
}
\arguments{
\item{x}{a vector of identifiers for each x in each pair This vector should 
have a unique value for each element in x.}

\item{y}{a vector of identifiers for each y in each pair This vector should 
have a unique value for each element in y.}

\item{w}{a vector with weights for each pair. The algorithm will try to 
maximise the total weight of the selected pairs.}

\item{n}{an integer. Each element of x can be linked to at most n elements of
y.}

\item{m}{an integer. Each element of y can be linked to at most m elements of
y.}
}
\description{
Force n to m matching on a set of pairs
}
\details{
The algorithm will try to select pairs in such a way each element of \code{x}
is matched to at most \code{n} elements of \code{y} and that each element of
\code{y} is matched at most \code{m} elements of \code{x}. It tries to select 
elements in such a way that the total weight \code{w} of the selected 
elements is maximised.
}
\examples{
d <- data.frame(x=c(1,1,1,2,2,3,3), y=c(1,2,3,4,5,6,7), w=1:7)
# One-to-one matching:
d[match_n_to_m(d$x, d$y, d$w), ]

# N-to-one matching:
d[match_n_to_m(d$x, d$y, d$w, n=999), ]

# One-to-m matching:
d[match_n_to_m(d$x, d$y, d$w, m=999), ]

# N-to-M matching, e.g. select all pairs
d[match_n_to_m(d$x, d$y, d$w, n=999, m=999), ]

}
