% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombinator.R
\name{heterogeneous_recombinator}
\alias{heterogeneous_recombinator}
\title{Process heterogeneous batch data.}
\usage{
heterogeneous_recombinator(dat, id = "id")
}
\arguments{
\item{dat}{list. The list of lists to process. Each row is a named list
with the names being variable names and the values being respective
variable values.}

\item{id}{character. Primary key, by default \code{"id"}.}
}
\value{
the formatted \code{data.frame}
}
\description{
This function turns a list of data obtained from the Avant API in
heterogeneous format into a \code{data.frame}. Here, heterogeneous refers
to a list of lists with each element being of possibly different size,
but a complete named list of the data for that row.
}
\details{
For example,
 \code{list(list(variable_one = 1, variable_two = 'a'),
            list(variable_one = 2, variable_three = 1))}
refers to a data set with three variables with two rows, the first variable
having \code{c(1,2)}, the second \code{c('a', NA)}, and the third \code{c(NA, 1)}.

If the list of lists is not formatted in this way, the function performs
no error handling and will likely return a malformed \code{data.frame}.
}
\examples{
pre_dataframe <-
  list(list(variable_one = 1, variable_two = 'a'),
       list(variable_one = 2, variable_three = 1))
df <- heterogeneous_recombinator(pre_dataframe)
# 3 by 2 dataframe w/ c(1,2), c('a', NA), c(NA, 1) in the columns, respectively.
}
