% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributeAssignment.R
\name{stripHTMLandUnicode}
\alias{stripHTMLandUnicode}
\alias{unitsFieldAnnotation}
\title{Helper Functions for \code{exportRecordsType} Attributes}
\usage{
stripHTMLandUnicode(field_name, field_label, field_annotation)

unitsFieldAnnotation(field_name, field_label, field_annotation)
}
\arguments{
\item{field_name}{\code{character}. Name of the fields.}

\item{field_label}{\code{character}. Labels from meta data.}

\item{field_annotation}{\code{character}. Annotations from meta_data.}
}
\value{
\code{stripHTMLandUnicode} returns a character vector.

\code{unitsFieldAnnotation} returns a character vector.
}
\description{
These functions assist in setting attributes for
columns of the resulting type cast data.frame.
}
\details{
Functions passed into the \code{assignment} argument list of
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}} construct attributes on a column.
They are expected to have a signature of \verb{function(field_name, field_label, field_annotation)} and return the attribute to assign or \code{NA}.
They must be vectorized.

Useful utilities are provided in \code{\link[=stringCleanup]{stringCleanup()}}

\code{stripHTMLandUnicode} strips both HTML and UNICODE from the \code{field_label}.

\code{unitsFieldAnnotation} pulls a units string from the field_annotation.
An example of the form searched for is \verb{units=\\\{"meters"\\\}}
}
\examples{
\dontrun{
stripHTMLandUnicode("field_name", "<b>Field label</b>", "field annotation")

unitsFieldAnnotation("field", "label", "units={\"meters\"}")
}

}
\seealso{
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportReportsTyped]{exportReportsTyped()}}, \cr
\code{\link[=stripHTMLTags]{stripHTMLTags()}}, \cr
\code{\link[=stripUnicode]{stripUnicode()}}
}
