% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFromFileRepository.R
\name{exportFromFileRepository}
\alias{exportFromFileRepository}
\alias{exportFromFileRepository.redcapApiConnection}
\title{Export a File from the File Repository}
\usage{
exportFromFileRepository(rcon, doc_id, dir = getwd(), dir_create = FALSE, ...)

\method{exportFromFileRepository}{redcapApiConnection}(
  rcon,
  doc_id,
  dir = getwd(),
  dir_create = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{\code{redcapApiConnection} object.}

\item{doc_id}{\code{integerish(1)}. The document ID to be downloaded}

\item{dir}{\code{character(1)}. A directory on the local system to which 
the file is to be saved. Defaults to the working directory.}

\item{dir_create}{\code{logical(1)}. Create the directory \code{dir} 
if it does not already exist. Defaults to FALSE. 
If dir does not exist and create = FALSE, an error is thrown.}

\item{...}{Additional arguments to be passed between methods}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Returns a \code{data.frame} with the directory and 
  filename of the saved file.
}
\description{
This method allows you to download a single file stored in the 
  File Repository by providing the file's \code{doc_id} number. For options
  to export multiple files, see \code{exportFileRepository}.
}
\author{
Benjamin Nutter
}
