% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_a_plan.R
\name{persily}
\alias{persily}
\title{Local Plan Optimization}
\usage{
persily(plan, map, counties = NULL)
}
\arguments{
\item{plan}{a single plan to optimize from}

\item{map}{a redist map object}

\item{counties}{Required}
}
\value{
a redist_plans object with one plan
}
\description{
Searches the local area for a combination of minimizing county splits, compactness,
population parity, and keeping close to the original plan
}
\examples{
\donttest{
data(iowa)
map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01, total_pop = pop)
plan <- get_plans_matrix(redist_smc(map, 1))[,2]
local <- persily(plan = plan, map = map, counties = region)
}
}
