% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parity.R, R/tidy.R
\name{redist.parity}
\alias{redist.parity}
\alias{plan_parity}
\title{Calculates Maximum Deviation from Population Parity}
\usage{
redist.parity(plans, total_pop)

plan_parity(map, .data = cur_plans(), ...)
}
\arguments{
\item{plans}{A matrix with one row for each precinct and one column for each
map. Required.}

\item{total_pop}{A numeric vector with the population for every precinct.}

\item{map}{a \code{\link{redist_map}} object}

\item{.data}{a \code{\link{redist_plans}} object}

\item{...}{passed on to \code{redist.parity}}
}
\value{
numeric vector with the population parity for each column
}
\description{
Computes the deviation from population parity from a plan.
Higher values indicate that (at least) a single district in the map deviates
from population parity. See Details.
}
\details{
With a map with \code{pop} representing the populations of each district,
the deviation from population parity is given as \code{max(abs(pop - parity) / parity)}
where \code{parity = sum(pop)/length(pop)} is the population size for the
average district.
Therefore, the metric can be thought of as the maximum percent deviation from
equal population. For example, a value of 0.03 in this metric indicates that
all districts are within 3 percent of population parity.
}
\concept{analyze}
