% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_AAseq.R
\name{refseq_AAseq}
\alias{refseq_AAseq}
\title{Extract the amino acid sequence into a Biostrings object}
\usage{
refseq_AAseq(xp)
}
\arguments{
\item{xp}{A character string containing a single/multiple XP ids.}
}
\value{
An object of \code{AAStringSet} class.
}
\description{
\code{refseq_AAseq()} Parses a single/multiple XP accessions (GenBank format) and extract
the amino acid sequences into a \code{AAStringSet} object.
}
\examples{
\donttest{
xp = c("XP_004487758", "XP_004488550", "XP_004501961")
my_aa <- refseq_AAseq(xp)}
# Now, the `AAStringSet`can be easily used to make a fasta file :
# writeXStringSet(x= my_aa, filepath = "aa_result")


}
\author{
Jose V. Die
}
