% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_mol_wt.R
\name{refseq_mol_wt}
\alias{refseq_mol_wt}
\title{Extract the molecular weigth from an XP accession}
\usage{
refseq_mol_wt(xp)
}
\arguments{
\item{xp}{A character string of the XP id.}
}
\value{
A numeric vector represeting the molecular weight of the protein(s) especified as \code{xp}.
}
\description{
\code{refseq_mol_wt()} Parses an XP accession output (Genbank format) and extract the molecular weight
(in Daltons).
}
\details{
First, get the character vector containing the fetched record. Then, this
function parses the fectched record and returns the molecular weight.
}
\examples{
 # Get the molecular weight from a single XP accession
 xp <- "XP_020244413"
 refseq_mol_wt(xp)

 # Get the molecular weight from from a set of XP accessions
 xp = c("XP_004487758", "XP_004488550")
 sapply(xp, function(x) refseq_mol_wt(x), USE.NAMES = TRUE)

}
\author{
Jose V. Die
}
