% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gibbs_Mult_Wish.R
\name{gibbs_mult_wish}
\alias{gibbs_mult_wish}
\title{Multilevel FoSR using a Gibbs sampler and Wishart prior}
\usage{
gibbs_mult_wish(formula, Kt = 5, data = NULL, verbose = TRUE,
  N.iter = 5000, N.burn = 1000, alpha = 0.1, Az = NULL, Bz = NULL,
  Aw = NULL, Bw = NULL, v = NULL, SEED = NULL)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{data}{an optional data frame, list or environment containing the
variables in the model. If not found in data, the variables are taken from
environment(formula), typically the environment from which the function is
called.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{N.iter}{number of iterations used in the Gibbs sampler}

\item{N.burn}{number of iterations discarded as burn-in}

\item{alpha}{tuning parameter balancing second-derivative penalty and
zeroth-derivative penalty (alpha = 0 is all second-derivative penalty)}

\item{Az}{hyperparameter for inverse gamma controlling variance of spline terms
for subject-level effects}

\item{Bz}{hyperparameter for inverse gamma controlling variance of spline terms
for subject-level effects}

\item{Aw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{Bw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{v}{hyperparameter for inverse Wishart prior on residual covariance}

\item{SEED}{seed value to start the sampler; ensures reproducibility}
}
\description{
Fitting function for function-on-scalar regression for multilevel data.
This function estimates model parameters using a Gibbs sampler and estimates
the residual covariance surface using a Wishart prior.
}
\references{
Goldsmith, J., Kitago, T. (2016).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical 
Function-on-Scalar Regression. \emph{Journal of the Royal Statistical Society:
Series C}, 65 215-236.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
