% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLS_CS.R
\name{ols_cs}
\alias{ols_cs}
\title{Cross-sectional FoSR using GLS}
\usage{
ols_cs(formula, data = NULL, Kt = 5, basis = "bs", verbose = TRUE)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{data}{an optional data frame, list or environment containing the 
variables in the model. If not found in data, the variables are taken from 
environment(formula), typically the environment from which the function is 
called.}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{basis}{basis type; options are "bs" for b-splines and "pbs" for periodic
b-splines}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}
}
\description{
Fitting function for function-on-scalar regression for cross-sectional data.
This function estimates model parameters using GLS: first, an OLS estimate of 
spline coefficients is estimated; second, the residual covariance is estimated
using an FPC decomposition of the OLS residual curves; finally, a GLS estimate
of spline coefficients is estimated. Although this is in the `BayesFoSR` package,
there is nothing Bayesian about this FoSR.
}
\references{
Goldsmith, J., Kitago, T. (2016).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical 
Function-on-Scalar Regression. \emph{Journal of the Royal Statistical Society:
Series C}, 65 215-236.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
