% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfpca.R
\name{bfpca_argPreparation}
\alias{bfpca_argPreparation}
\title{Internal main preparation function for bfpca}
\usage{
bfpca_argPreparation(
  Y,
  Kt,
  time,
  t_min,
  t_max,
  periodic,
  seed,
  subsample,
  verbose
)
}
\arguments{
\item{Y, time, t_min, t_max}{Internal objects created in \code{bfpca}.}

\item{Kt}{Number of B-spline basis functions used to estimate mean functions
and functional principal components. Default is 8. If \code{npc_varExplained}
is used, \code{Kt} is set to 20.}

\item{periodic}{If TRUE, uses periodic b-spline basis functions. Default is FALSE.}

\item{seed}{Set seed for reproducibility. Defaults to 1988.}

\item{subsample}{if the number of rows of the data is greater than 
10 million rows, the `id` values are subsampled to get the mean coefficients.}

\item{verbose}{Can be set to integers between 0 and 4 to control the level of
detail of the printed diagnostic messages. Higher numbers lead to more detailed
messages. Defaults to 1.}
}
\value{
List with elements \code{knots}, \code{Theta_phi}, \code{xi},
\code{alpha_coefs}.
}
\description{
Internal main preparation function for bfpca
}
