% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_fit_yreg_outcome_modeling.R
\name{fit_yreg}
\alias{fit_yreg}
\title{Fit a model for the outcome given the treatment, mediator, and covariates.}
\usage{
fit_yreg(yreg, data, yvar, avar, mvar, cvar, eventvar, interaction)
}
\arguments{
\item{yreg}{A character vector of length 1. Outcome regression type: \code{"linear"}, \code{"logistic"}, \code{"loglinear"}, \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.}

\item{data}{Data frame containing the relevant variables.}

\item{yvar}{A character vector of length 1. Outcome variable name. It should be the time variable for survival outcomes.}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there should usually be some confounder(s) to account for the common cause structure (confounding) between \code{avar} and \code{yvar}.}

\item{eventvar}{An character vector of length 1. Only required for survival outcome regression models. Note that the coding is 1 for event and 0 for censoring, following the R survival package convention.}

\item{interaction}{A logical vector of length 1. Default to TRUE. Whether to include a mediator-treatment interaction term in the outcome regression model.}
}
\value{
Model fit object from on of the above regression functions.
}
\description{
The outcome model type \code{yreg} can be one of the following \code{"linear"}, \code{"logistic"}, \code{"loglinear"} (implemented as modified Poisson), \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.
}
\details{
The outcome regression functions to be called are the following:
\itemize{
  \item \code{"linear"} \code{\link{lm}}
  \item \code{"logistic"} \code{\link{glm}}
  \item \code{"loglinear"} \code{\link{glm}} (modified Poisson)
  \item \code{"poisson"} \code{\link{glm}}
  \item \code{"negbin"} \code{\link[MASS]{glm.nb}}
  \item \code{"survCox"} \code{\link[survival]{coxph}}
  \item \code{"survAFT_exp"} \code{\link[survival]{survreg}}
  \item \code{"survAFT_weibull"} \code{\link[survival]{survreg}}
}
}
