% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_regions.R
\name{extract_regions}
\alias{extract_regions}
\title{Extract regions from a scan}
\usage{
extract_regions(scan, regions, right = TRUE)
}
\arguments{
\item{scan}{A data frame with chromosomal positions like obtained
by \code{\link{scan_hh}}, \code{\link{ihh2ihs}}, \code{\link{ines2rsb}} or \code{\link{ies2xpehh}}.}

\item{regions}{A data frame with genomic regions like the output of \code{\link{calc_candidate_regions}}.}

\item{right}{logical, indicating if the intervals should be closed on the right (and open on the left) or vice versa.}
}
\value{
A subset of data frame \code{scan}, retaining only positions belonging to
the regions specified in data frame \code{regions}.
}
\description{
Extract regions from a scan data frame.
}
\examples{
library(rehh.data)
data(wgscan.cgu)
regions <- data.frame(CHR = 12, START = 2.88e+7, END = 2.92e+7)
extract_regions(wgscan.cgu, regions)
}
