\name{breedFst}
\alias{breedFst}
\title{Breed a population with an approximate level of \eqn{\theta}{theta}(\eqn{F_{ST}}{Fst})}
\description{This function simulates a population with an approximate
  level of population substructure. This is achieved by subdividing a
  population into equal sized subpopulations and allowing them to breed
  within themselves for
  \deqn{t =
    \lceil{\frac{\log_e(1-\theta)}{\log\left(1-\frac{1}{2N_s}\right)}}\rceil}{t =
    ceiling(log(1-theta)/log(1-1/(2*Ns)))}
  generations, where \eqn{N_s}{Ns} is the number of individuals in each
  subpopulation. This will produce a population with an estimated coancestry
  coefficient approximately equal to \eqn{\theta}{theta}
}
\usage{
breedFst(Freqs, theta = 0.01, N = 10000, ns = 10, DNAtools = FALSE)
}
\arguments{
  \item{Freqs}{A list with an element, \code{freqs} which contains a list of vectors, where each vector is a set of allele
    frequencies for a locus}
  \item{theta}{A desired level of inbreeding, where \eqn{0 < \theta <
      0.5}{0 < theta < 0.5}}
  \item{N}{Total population size}
  \item{ns}{The number of subpopulations. \eqn{N/n_s}{N/ns} needs to be
    greater than 100}
  \item{DNAtools}{If \code{TRUE} then the profiles in the return
    population will be formatted as a data frame with an id column and
    two columns per locus.}
}
\value{
  An object of class 'population' which is a list with the following
  elements
  \itemize{
    \item \code{profiles} -  a vector of profiles where the level of
    inbreeding is approximately equal to \eqn{\theta}{theta}
    \item \code{nProfiles} - the total number of individuals in the
    population
    \item \code{nSubpops} - the number of sub-populations in the
    population
    \item \code{nLoci} - the number of loci each individual is typed at
    \item \code{theta} - the desired level of substructure in the
    population. The actual value will be near to this.
    \item \code{Freqs} - a Freq object representing the ancestral
    frequencies of the population
    }
}
\examples{
data(USCaucs)
pop = breedFst(USCaucs)
}
\author{James M. Curran}
