% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioc.R
\name{bioc_version}
\alias{bioc_version}
\alias{bioc_install_repos}
\title{Tools for Bioconductor repositories}
\usage{
bioc_version(r_ver = getRversion())

bioc_install_repos(r_ver = getRversion(),
  bioc_ver = bioc_version(r_ver))
}
\arguments{
\item{r_ver}{R version to use. For \code{bioc_install_repos()} it is
ignored if \code{bioc_ver} is specified.}

\item{bioc_ver}{Bioconductor version to use. Defaults to the default one
corresposding to \code{r_ver}.}
}
\value{
\code{bioc_version()} returns a Bioconductor version, a \code{package_version}
object.

\code{bioc_install_repos()} returns a named character vector of the URLs of
the BioConductor repositories, appropriate for the current or the
specified R version.
}
\description{
\code{bioc_version()} returns the Bioconductor version for the current or the
specified R version.
}
\details{
\code{bioc_install_repos()} deduces the URLs of the BioConductor repositories.

Both functions observe the \code{R_BIOC_VERSION} environment variable, which
can be set to force a Bioconductor version. If this is set, then the
\code{r_ver} and \code{bioc_ver} arguments are ignored.

\code{bioc_install_repos()} observes the \code{R_BIOC_MIRROR} enironment variable
and also the \code{BioC_mirror} option, which can be set to the desired
Bioconductor mirror. The option takes precedence if both are set. Its
default value is \code{https://bioconductor.org}.
}
\examples{
bioc_version()
bioc_version("3.4")
bioc_install_repos()
}
\keyword{internal}
