% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-bioc.R
\name{install_bioc}
\alias{install_bioc}
\title{Install a development package from the Bioconductor git repository}
\usage{
install_bioc(repo, mirror = getOption("BioC_git",
  download_url("git.bioconductor.org/packages")), git = c("auto",
  "git2r", "external"), dependencies = NA, upgrade = c("default",
  "ask", "always", "never"), force = FALSE, quiet = FALSE,
  build = TRUE, build_opts = c("--no-resave-data", "--no-manual",
  "--no-build-vignettes"), build_manual = FALSE,
  build_vignettes = FALSE, repos = getOption("repos"),
  type = getOption("pkgType"), ...)
}
\arguments{
\item{repo}{Repository address in the format
\code{[username:password@][release/]repo[#commit]}. Valid values for
the release are \sQuote{devel},
\sQuote{release} (the default if none specified), or numeric release
numbers (e.g. \sQuote{3.3}).}

\item{mirror}{The bioconductor git mirror to use}

\item{git}{Whether to use the \code{git2r} package, or an external
git client via system. Default is \code{git2r} if it is installed,
otherwise an external git installation.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).}

\item{upgrade}{One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \code{R CMD build}, only used when \code{build}}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').
is \code{TRUE}.}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function requires \code{git} to be installed on your system in order to
be used.
}
\details{
It is vectorised so you can install multiple packages with
a single command.

This is intended as an aid for Bioconductor developers. If you want to
install the release version of a Bioconductor package one can use the
\code{BiocManager} package.
}
\examples{
\dontrun{
install_bioc("SummarizedExperiment")
install_bioc("release/SummarizedExperiment")
install_bioc("3.3/SummarizedExperiment")
install_bioc("SummarizedExperiment#abc123")
install_bioc("user:password@release/SummarizedExperiment")
install_bioc("user:password@devel/SummarizedExperiment")
install_bioc("user:password@SummarizedExperiment#abc123")
}
}
\seealso{
Other package installation: \code{\link{install_bitbucket}},
  \code{\link{install_cran}}, \code{\link{install_dev}},
  \code{\link{install_github}},
  \code{\link{install_gitlab}}, \code{\link{install_git}},
  \code{\link{install_local}}, \code{\link{install_svn}},
  \code{\link{install_url}}, \code{\link{install_version}}
}
\concept{package installation}
