% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-git.R
\name{parse-git-repo}
\alias{parse-git-repo}
\alias{parse_repo_spec}
\alias{parse_github_repo_spec}
\alias{parse_github_url}
\title{Parse a remote git repo specification}
\usage{
parse_repo_spec(repo)

parse_github_repo_spec(repo)

parse_github_url(repo)
}
\arguments{
\item{repo}{Character scalar, the repo specification.}
}
\value{
List with members: \code{username}, \code{repo}, \code{subdir}
\code{ref}, \code{pull}, \code{release}, some which will be empty.
}
\description{
A remote repo can be specified in two ways:
\describe{
\item{as a URL}{\code{parse_github_url()} handles HTTPS and SSH remote URLs
and various GitHub browser URLs}
\item{via a shorthand}{\code{parse_repo_spec()} handles this concise form:
\code{[username/]repo[/subdir][#pull|@ref|@*release]}}
}
}
\examples{
parse_repo_spec("metacran/crandb")
parse_repo_spec("jimhester/covr#47")        ## pull request
parse_repo_spec("jeroen/curl@v0.9.3")       ## specific tag
parse_repo_spec("tidyverse/dplyr@*release") ## shorthand for latest release
parse_repo_spec("r-lib/remotes@550a3c7d3f9e1493a2ba") ## commit SHA
parse_repo_spec("igraph=igraph/rigraph") ## Different package name from repo name

parse_github_url("https://github.com/jeroen/curl.git")
parse_github_url("git@github.com:metacran/crandb.git")
parse_github_url("https://github.com/jimhester/covr")
parse_github_url("https://github.example.com/user/repo.git")
parse_github_url("git@github.example.com:user/repo.git")

parse_github_url("https://github.com/r-lib/remotes/pull/108")
parse_github_url("https://github.com/r-lib/remotes/tree/name-of-branch")
parse_github_url("https://github.com/r-lib/remotes/commit/1234567")
parse_github_url("https://github.com/r-lib/remotes/releases/latest")
parse_github_url("https://github.com/r-lib/remotes/releases/tag/1.0.0")
}
