% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{difference}
\alias{difference}
\title{difference}
\usage{
difference(
  variable,
  attr_actors = NULL,
  scaling = c("none", "std"),
  absolute = TRUE,
  attr_data
)
}
\arguments{
\item{variable}{string with the name of the column in the
\code{attr_actors} object for which the statistic has to be computed.}

\item{attr_actors}{optionally, an object of class
\code{\link[base]{data.frame}} that contains the attribute, see
'Details.'}

\item{scaling}{the method for scaling the statistic. Default is to not scale
the statistic. Alternatively, standardization of the
statistic per time point can be requested with "std".}

\item{absolute}{Logical value indicating whether the difference values
should be converted to the absolute difference (default is TRUE).}

\item{attr_data}{Deprecated argument. Please use 'attr_actors' instead.}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a "difference" effect in the tie-oriented model
or the receiver choice step of the actor-oriented model. A difference effect
refers to an exogenous actor attribute that affects dyad \emph{(i,j)}'s rate
of interacting (tie-oriented model) or actor \emph{j}'s probability of being
chosen as a receiver for the event send by the active sender \emph{i} at
time \emph{t} (actor-oriented model) based on the difference between the
values of actors \emph{i} and \emph{j} on this attribute.
}
\details{
The statistic at timepoint \emph{t} is equal to the (absolute) difference
between the values of actor \emph{i} and \emph{j} on the attribute at
timepoint \emph{t}.

Construct the `attr_actors` object as a data frame where each row represents 
the attribute value of actor \emph{i} at timepoint \emph{t}:
\itemize{
  \item{name:} The actors' name.
  \item{time:} The time when the attribute values change.
  \item{variable:} The third column contains the attribute used in the
  specification of the "difference" effect. The column name should correspond
  to the string supplied to the \code{variable} argument in the `difference()`
  function.
}

Note that it is possible to omit the `attr_actors` object in the call of
\code{difference()} and, instead, supply it in the call of \code{remstats()}
for multiple exogenous effects.

Note that it is possible to omit the `attr_actors` object in the call of
\code{difference()} and, instead, supply it in the call of \code{remstats()}
for multiple exogenous effects.
}
\examples{
# Example for tie-oriented model
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ difference("extraversion", absolute = TRUE)
remstats(reh = reh_tie, tie_effects = effects, attr_actors = info)

# Example for actor-oriented model
reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, receiver_effects = effects, attr_actors = info)

}
