% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gif.R
\name{to_gif}
\alias{to_gif}
\title{Render slides as a GIF file.}
\usage{
to_gif(
  from,
  to = NULL,
  density = 100,
  slides = "all",
  fps = 1,
  complex_slides = FALSE,
  partial_slides = FALSE,
  delay = 1,
  keep_intermediates = FALSE
)
}
\arguments{
\item{from}{Path to an \code{.Rmd}, \code{.qmd}, \code{.html}, \code{.pdf} file, or a URL. If
\code{from} is a URL to slides on a website, you must provide the full URL
ending in \code{".html"}.}

\item{to}{Name of the output \code{.gif} file.}

\item{density}{Resolution of the resulting PNGs in each slide file. Defaults
to \code{100}.}

\item{slides}{A numeric or integer vector of the slide number(s) to include
in the GIF, or one of \code{"all"}, \code{"first"}, or \code{"last"}. Negative integers
select which slides \emph{not} to include. Defaults to \code{"all"}, in which case
all slides are included.}

\item{fps}{Frames per second in the animated GIF.}

\item{complex_slides}{For "complex" slides (e.g. slides with panelsets or
other html widgets or advanced features), set \code{complex_slides = TRUE}.
Defaults to \code{FALSE}. This will use the {chromote} package to iterate
through the slides at a pace set by the \code{delay} argument. Requires a local
installation of Chrome.}

\item{partial_slides}{Should partial (continuation) slides be included in the
output? If \code{FALSE}, the default, only the complete slide is included in the
PDF.}

\item{delay}{Seconds of delay between advancing to and printing a new slide.
Only used if \code{complex_slides = TRUE} or \code{partial_slides = TRUE}.}

\item{keep_intermediates}{Should we keep the intermediate files used to
render the final output? The default is \code{FALSE}.}
}
\value{
Slides are rendered as a \code{.gif} file.
}
\description{
Render slides as a GIF video file. The function renders to the PDF,
converts each slide in the PDF to a PNG, and then converts the deck of
PNG files to a GIF file.
}
\examples{
with_example("slides.Rmd", requires_chrome = TRUE, {
    # Render gif from Rmd, html, pdf, or direct URL
    to_gif("slides.Rmd")
})
}
