% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade.R
\name{upgrade}
\alias{upgrade}
\title{Upgrade renv}
\usage{
upgrade(project = NULL, version = NULL, reload = NULL, prompt = interactive())
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{version}{The version of \code{renv} to be installed. By default, the latest
version of \code{renv} as available on the active R package repositories is
used.}

\item{reload}{Boolean; reload \code{renv} after install? When \code{NULL} (the
default), \code{renv} will be re-loaded only if updating \code{renv} for the
active project. Note that this may fail if you've loaded packages
which also depend on \code{renv}.}

\item{prompt}{Boolean; prompt upgrade before proceeding?}
}
\value{
A boolean value, indicating whether the requested version of
\code{renv} was successfully installed. Note that this function is normally
called for its side effects.
}
\description{
Upgrade the version of \code{renv} associated with a project.
}
\details{
By default, this function will attempt to install the latest version of
\code{renv} as available on the active R package repositories. If you'd instead
like to try out a development version of \code{renv}, you can explicitly request a
different version of \code{renv} and that version of the package will be
downloaded and installed from GitHub. Use \code{version = "master"} to install the
latest development version of \code{renv}, as from the \code{renv} project's \href{https://github.com/rstudio/renv}{GitHub page}.
}
\examples{
\dontrun{

# upgrade to the latest version of renv
renv::upgrade()

# upgrade to the latest version of renv on GitHub (development version)
renv::upgrade(version = "master")

}
}
