% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/replicationInterval.R
\name{ri.d}
\alias{ri.d}
\title{Creates a replication interval based for a \emph{d}-value (i.e., standardized mean difference)}
\usage{
ri.d(d, n1, n2, rep.n1 = NA, rep.n2 = NA, conf.level = 0.95,
  explain = FALSE, extended.output = FALSE, manuscript.text = TRUE)
}
\arguments{
\item{d}{Original study: Sample \emph{d}-value (standardized mean difference) created with pooled variance denominator. See formulas 4.18 and 4.19 (p.26) in Borenstein, Hedges, Higgins, & Rothstein (2009).}

\item{n1}{Original study: Sample size for group 1}

\item{n2}{Original study: Sample size for group 2}

\item{rep.n1}{(optional) Replication study: Sample size for group 1. If not specified, n1 is used.}

\item{rep.n2}{(optional) Replication study: Sample size for group 2. If not specified, n2 is used.}

\item{conf.level}{(optional 0 to 1 value) Confidence level desired (0 to 1). If not specified .95 (i.e., 95 percent) will be used.}

\item{explain}{(optional boolean) Default is FALSE. If TRUE, text output explaining the interval is provided.}

\item{extended.output}{(optional boolean) Default is FALSE. If TRUE, additional details (e.g., confidence interval) provided in numeric return output.}

\item{manuscript.text}{(optional boolean) Default is TRUE. If TRUE, present text for Method section.}
}
\value{
A list of values (\code{lower.replication.interval.d, upper.replication.interval.d}) containing the replication interval (and related statistics if requested with the \code{extended.output} argument).
}
\description{
Creates a replication interval based for a \emph{d}-value (i.e., standardized mean difference)
}
\examples{
ri.d(d=.65,n1=20,n2=20)
ri.d(d=.65,n1=20,n2=20,explain=TRUE)
}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P., & Rothstein, H. R. (2009). \emph{Introduction to meta-analysis}. John Wiley & Sons.\cr\cr
Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and calculation of confidence intervals that are based on central and noncentral distributions. \emph{Educational and Psychological Measurement, 61(4)}, 532-574.
}

