% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_date.R
\name{package_date}
\alias{package_date}
\title{Find earliest date of compatibility}
\usage{
package_date(packages = ".", which = "strong")
}
\arguments{
\item{packages}{Path to the package folder and/or name of packages published.}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }
}
\value{
A vector with the datetimes of the published package (or current
date if not published) and the datetime when the requirements were met.
}
\description{
Search the DESCRIPTION file for the release dates of dependencies and return the earliest date according to CRAN's archive.
This is the date at which the package could be installed.
}
\details{
Currently this function assumes that packages only use ">=" and not other operators.
This might change on the future if other operators are more used.
}
\examples{
package_date("ABACUS")
package_date("paramtest")
package_date("Seurat") # Dependencies on packages not on CRAN
package_date("afmToolkit") # Dependency was removed from CRAN
}
\seealso{
Other utilities: 
\code{\link{cran_date}()},
\code{\link{cran_doom}()},
\code{\link{cran_snapshot}()},
\code{\link{duplicated_alias}()},
\code{\link{package_repos}()},
\code{\link{repos_dependencies}()},
\code{\link{update_dependencies}()}
}
\concept{utilities}
