% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repos.R
\name{package_repos}
\alias{package_repos}
\title{Package dependencies to repositories}
\usage{
package_repos(packages = NULL, repos = getOption("repos"), which = "all")
}
\arguments{
\item{packages}{a character vector of package names.}

\item{repos}{Repositories and their names are taken from \code{getOptions("repos")}.}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }
}
\value{
A data.frame with one line per package and at least one column per
repository. It also has a column for Other repositories (Additional_repositories,
or missing repositories), and the total number of dependencies and total
number of repositories used.
}
\description{
Explore the relationships between packages and repositories available.
}
\examples{
pr <- package_repos("experDesign")
head(pr)
}
\seealso{
Other utilities: 
\code{\link{cran_date}()},
\code{\link{cran_doom}()},
\code{\link{cran_snapshot}()},
\code{\link{duplicated_alias}()},
\code{\link{package_date}()},
\code{\link{repos_dependencies}()},
\code{\link{update_dependencies}()}
}
\concept{utilities}
