% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{repos_dependencies}
\alias{repos_dependencies}
\title{Tidy dependencies}
\usage{
repos_dependencies(packages = NULL, which = "all")
}
\arguments{
\item{packages}{a character vector of package names.}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }
}
\value{
A data.frame with 5 columns: the name of the dependency,
the operator (op), the version it depends the type of dependency and the package.
\code{NA} if not able to collect the data from CRAN.
}
\description{
Extract the packages dependencies, name of the dependency, operator and version
for each type and package of current repositories (\code{getOptions("repos")}).
}
\examples{
rd <- repos_dependencies("BaseSet")
head(rd)
}
\seealso{
Other utilities: 
\code{\link{cran_date}()},
\code{\link{cran_doom}()},
\code{\link{cran_snapshot}()},
\code{\link{duplicated_alias}()},
\code{\link{package_date}()},
\code{\link{package_repos}()},
\code{\link{update_dependencies}()}
}
\concept{utilities}
