% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_style.R
\name{add_style}
\alias{add_style}
\title{Add a style object to a report.}
\usage{
add_style(rpt, style = NULL, theme = NULL)
}
\arguments{
\item{rpt}{The report specification to add a style to.}

\item{style}{A style object which contains style settings to add to the 
report. This parameter is optional.  Default is NULL.}

\item{theme}{A theme name to use for this report. Valid values are
"MidnightBlue", "SteelBlue", "DarkRed", "SeaGreen", "SlateGrey", "Plain", 
and "SASDefault".  Default is NULL.}
}
\description{
This function will add a style object to a report specification.  The 
style may be added either by passing a style object to the \code{style} 
parameter, or by passing a theme name to the \code{theme} parameter.
}
\details{
The \code{add_style()} function allows you to add styling to HTML reports.
This functionality will apply to additional output types in future
versons of the \strong{reporter} package.

Styling can be added by passing a named theme to the \code{theme} parameter,
or by creating a style object using the \code{\link{create_style}} function
and passing that object to the \code{style} parameter.  You may also export 
a theme as a style object using the \code{\link{get_theme}} function,
modify it, and pass that to the \code{style} parameter.
}
\section{Style Specifications}{

The style specification is created using the \code{\link{create_style}} function,
and provides the most styling flexibility.  The style object allows you
to control background colors, font colors, border colors, and more.  Colors
can be specified using an RGB hex code, or an HTML/CSS-compliant color name.
See the \code{\link{create_style}} documentation for additional information.
}

\section{Themes}{

There are currently seven themes available: "MidnightBlue", "SteelBlue", 
"DarkRed", "SeaGreen", "SlateGrey", "Plain", and "SASDefault". 
All themes use Arial 10pt font. These themes are intended to provide a 
basic set of examples on how to create styles. Themes can be used by 
passing the theme name to the theme parameter on the \code{add_style()}
function. The theme will assign a variety of style settings according 
to the specifics of the theme.  For example, the "MidnightBlue" theme
sets the title font and header background colors to "MidnightBlue" and sets
the border color to "Grey".

To view theme style settings, you can use \code{\link{get_theme}} function. 
This function will return the theme as a style object.  See
the \code{\link{get_theme}} documentation for further details.
}

\examples{
library(reporter)
library(magrittr)

# Prepare data
dat <- as.data.frame(HairEyeColor)
dat <- dat[dat$Freq >= 10, ]

## Example 1: Use Pre-defined Theme ##

# Create temp file path
tmp1 <- file.path(tempdir(), "HairAndEyes1.html")

# Create table object
tbl <- create_table(dat, borders = "outside") \%>\% 
titles("Hair and Eye Colors with Theme") \%>\% 
column_defaults(width = .6)

# Create report and add theme
rpt <- create_report(tmp1, output_type = "HTML") \%>\% 
       add_content(tbl) \%>\% 
       add_style(theme = "SteelBlue")

# Write out the report        
write_report(rpt)

# Uncomment to View report
# file.show(tmp1)

#' ## Example 2: Create Custom Style ##

# Create temp file path
tmp2 <- file.path(tempdir(), "HairAndEyes2.html")

# Define custom style
sty <- create_style(font_name = "Times",
                    font_size = 10,
                    title_font_size = 12,
                    title_font_bold = TRUE,
                    title_font_color = "Blue",
                    table_header_background = "Blue",
                    table_header_font_bold = TRUE,
                    table_header_font_color = "White",
                    table_body_background = "White",
                    table_body_stripe = "Red")

# Create table object
tbl <- create_table(dat, borders = "outside") \%>\% 
titles("Hair and Eye Colors with Style") \%>\% 
column_defaults(width = .6)

# Create report and add style spec
rpt <- create_report(tmp2, output_type = "HTML") \%>\% 
       add_content(tbl) \%>\% 
       add_style(style = sty)

# Write out the report        
write_report(rpt)

# Uncomment to View report
# file.show(tmp2)
}
\seealso{
Other styles: 
\code{\link{create_style}()},
\code{\link{get_theme}()},
\code{\link{print.style_spec}()}
}
\concept{styles}
