% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{AnalyseResiduals}
\alias{AnalyseResiduals}
\title{AnalyseResiduals}
\usage{
AnalyseResiduals(Residuals, ExperimentName = "ExpName")
}
\arguments{
\item{Residuals}{a vector of residuals}

\item{ExperimentName}{a character string identifying the data set}
}
\value{
A dataframe identifying the ExperimentName and its associated sample parameter: Length, Mean, Median, Variance, Standard deviation, skewness, kurtosis, the outcome of the Shapiro and Anderson-Darling normality test and the number of outliers.
}
\description{
The function calculates sample statistics based on the residuals from a specified experiment
}
\examples{
ExpData=rnorm(30,0,1)
set.seed(123)
AnalyseResiduals(Residuals=ExpData,ExperimentName='ExpName')
#  ExperimentName       Mean      Median  Variance   Skewness Kurtosis ShapiroTest AndersonDarling
#1        ExpName -0.1396192 -0.01943395 0.8424521 -0.1964175 4.559587   0.1608315       0.1316835
#  NumOut
#  1
}
\author{
Barbara Kitchenham and Lech Madeyski
}
