% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepInputs.R
\name{extractFromArchive}
\alias{extractFromArchive}
\title{Extract files from archive}
\usage{
extractFromArchive(
  archive,
  destinationPath = getOption("reproducible.destinationPath", dirname(archive)),
  neededFiles = NULL,
  extractedArchives = NULL,
  checkSums = NULL,
  needChecksums = 0,
  filesExtracted = character(),
  checkSumFilePath = character(),
  quick = FALSE,
  ...
)
}
\arguments{
\item{archive}{Character string giving the path of the archive
containing the \code{file} to be extracted. This path must exist or be \code{NULL}}

\item{destinationPath}{Character string giving the path where \code{neededFiles} will be
extracted. Defaults to the archive directory.}

\item{neededFiles}{Character string giving the name of the file(s) to be extracted.}

\item{extractedArchives}{Used internally to track archives that have been extracted from.}

\item{checkSums}{A checksums file, e.g., created by Checksums(..., write = TRUE)}

\item{needChecksums}{A numeric, with \code{0} indicating do not write a new checksums,
\code{1} write a new one,
\code{2} append new information to existing one.}

\item{filesExtracted}{Used internally to track files that have been extracted.}

\item{checkSumFilePath}{The full path to the checksum.txt file}

\item{quick}{Passed to \code{Checksums}}

\item{...}{Passed to \code{unzip} or \code{untar}, e.g., \code{overwrite}}
}
\value{
A character vector listing the paths of the extracted archives.
}
\description{
Extract zip or tar archive files, possibly nested in other zip or tar archives.
}
\author{
Jean Marchal and Eliot McIntire
}
