% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra-migration.R
\name{minFn}
\alias{minFn}
\alias{maxFn}
\alias{dataType2}
\alias{nlayers2}
\alias{values2}
\title{Get min or maximum value of a (Spat)Raster}
\usage{
minFn(x)

maxFn(x)

dataType2(x, ...)

nlayers2(x)

values2(x, ...)
}
\arguments{
\item{x}{A \code{Raster} or \code{SpatRaster} object.}

\item{...}{Passed to the functions in \code{raster} or \code{terra}, as needed.}
}
\value{
A vector (not matrix as in \code{terra::minmax}) with the minimum or maximum
value on the \code{Raster} or \code{SpatRaster}, one value per layer.
}
\description{
During the transition from raster to terra, some functions are not drop in
replacements, such as \code{minValue} and \code{maxValue} became \code{terra::minmax}. This
helper allows one function to be used, which calls the correct max or min
function, depending on whether the object is a \code{Raster} or \code{SpatRaster}.
}
\examples{
if (requireNamespace("terra")) {
  ras <- terra::rast(terra::ext(0, 10, 0, 10), vals = 1:100)
  maxFn(ras)
  minFn(ras)
}
}
