% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_methods.R
\name{quantile.Distribution}
\alias{quantile.Distribution}
\title{Quantiles of Distributions}
\usage{
\method{quantile}{Distribution}(x, probs = seq(0, 1, 0.25), with_params = list(), ..., .start = 0)
}
\arguments{
\item{x}{A \code{Distribution}.}

\item{probs}{Quantiles to compute.}

\item{with_params}{Optional list of distribution parameters. Note that if \code{x$has_capability("quantile")} is false,
\code{with_params} is assumed to contain only one set of parameters.}

\item{...}{ignored}

\item{.start}{Starting value if quantiles are computed numerically. Must be within the support of \code{x}.}
}
\value{
The quantiles of \code{x} corresponding to \code{probs} with parameters \code{with_params}.
}
\description{
Produces quantiles corresponding to the given probabilities with configurable distribution parameters.
}
\details{
If \code{x$has_capability("quantile")} is true, this returns the same as \code{x$quantile(probs, with_params = with_params)}.
In this case, \code{with_params} may contain separate sets of parameters for each quantile to be determined.

Otherwise, a numerical estimation of the quantiles is done using the density and probability function.
This method assumes \code{with_params} to cantain only one set of parameters.
The strategy uses two steps:
\enumerate{
\item Find the smallest and largest quantiles in \code{probs} using a newton method starting from \code{.start}.
\item Find the remaining quantiles with bisection using \code{\link[stats:uniroot]{stats::uniroot()}}.
}
}
\examples{
# With quantiles available
dist <- dist_normal(sd = 1)
qqs <- quantile(dist, probs = rep(0.5, 3), with_params = list(mean = 1:3))
stopifnot(all.equal(qqs, 1:3))

# Without quantiles available
dist <- dist_erlangmix(shapes = list(1, 2, 3), scale = 1.0)
my_probs <- c(0, 0.01, 0.25, 0.5, 0.75, 1)
qqs <- quantile(
  dist, probs = my_probs,
  with_params = list(probs = list(0.5, 0.3, 0.2)), .start = 2
)

all.equal(dist$probability(qqs, with_params = list(probs = list(0.5, 0.3, 0.2))), my_probs)
# Careful: Numerical estimation of extreme quantiles can result in out-of-bounds values.
# The correct 0-quantile would be 0 in this case, but it was estimated < 0.
qqs[1L]

}
