% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_trunc.R
\name{dist_trunc}
\alias{dist_trunc}
\title{Truncated distribution}
\usage{
dist_trunc(dist = NULL, min = NULL, max = NULL, offset = 0, max_retry = 100)
}
\arguments{
\item{dist}{An underlying distribution, or \code{NULL} as a placeholder.}

\item{min}{Minimum value to truncate at (exclusive),
or \code{NULL} as a placeholder.}

\item{max}{Maxmimum value to truncate at (inclusive),
or \code{NULL} as a placeholder.}

\item{offset}{Offset to be added to each observation after truncation,
or \code{NULL} as a placeholder. Truncation of \code{dist} will occur to (min, max].
The offset is then added deterministically.}

\item{max_retry}{Maximum number of resample attempts when trying to sample
with rejection.}
}
\value{
A \code{TruncatedDistribution} object.
}
\description{
Truncated distribution
}
\examples{
d_norm <- dist_normal(mean = 0, sd = 1)
d_tnorm <- dist_trunc(dist = d_norm, min = -2, max = 2, offset = 1)
plot_distributions(d_norm, d_tnorm, .x = seq(-2, 3, length.out = 100))

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
