% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dsd.R
\name{extract_dsd}
\alias{extract_dsd}
\title{Extract values from XML}
\usage{
extract_dsd(concept = NULL, dsd_xml = NULL)
}
\arguments{
\item{concept}{a character vector with concept ids}

\item{dsd_xml}{an XML file with DSD content}
}
\value{
a matrix with 3 columns if the concepts has code list in the DSD file
}
\description{
Extracts the values from the XML Data Structure Definition (DSD) file
}
\details{
It is a subfunction to use in the \code{\link{get_eurostat_dsd}} function.
}
\examples{
\dontshow{
if ((parallel::detectCores()<2)|(Sys.info()[['sysname']]=='Windows')){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}    
}
dsd_url<-"http://ec.europa.eu/eurostat/SDMX/diss-web/rest/datastructure/ESTAT/DSD_nama_10_a10_e"
tryCatch({
  dsd_xml<-xml2::read_xml(dsd_url)}, 
  error=function(e){
  message("Unable to download the xml file.\\n",e)}, 
  warning=function(w){
  message("Unable to download the xml file.\\n",w)}) 
if (exists("dsd_xml")) {extract_dsd("GEO",dsd_xml)} 

}
