\name{restlos-package}
\alias{restlos-package}
\alias{restlos}
\docType{package}
\title{
Robust Estimation of Location and Scatter
}

\description{
The restlos package provides algorithms for robust estimation of location (mean and mode) and scatter based on minimum spanning trees (pMST), self-organizing maps (Flood Algorithm), Delaunay triangulations (RDELA), and nested minimum volume convex sets (MVCH). The functions are also suitable for outlier detection.
}

\details{
\tabular{ll}{
Package: \tab restlos\cr
Type: \tab Package\cr
Version: \tab 0.2-2\cr
Date: \tab 2015-08-09\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}

}
\author{
Steffen Liebscher and Thomas Kirschstein

Maintainer: Steffen Liebscher <steffen.liebscher@wiwi.uni-halle.de>
}

\references{
Kirschstein, T., Liebscher, S., and Becker, C. (2013): Robust estimation of location and scatter by pruning the minimum spanning tree, \emph{Journal of Multivariate Analysis}, 120, 173-184, DOI: 10.1016/j.jmva.2013.05.004.

Kirschstein, T., Liebscher, S., Porzio, G., Ragozini, G. (2015): Minimum volume peeling: a robust non-parametric estimator of the multivariate mode, \emph{Computational Statistics and Data Analysis}, DOI: 10.1016/j.csda.2015.04.012.

Liebscher, S., Kirschstein, T. (2015): Efficiency of the pMST and RDELA Location and Scatter Estimators, \emph{AStA-Advances in Statistical Analysis}, 99(1), 63-82, DOI: 10.1007/s10182-014-0231-7.

Liebscher, S., Kirschstein, T., and Becker, C. (2012): The Flood Algorithm - A Multivariate, Self-Organizing-Map-Based, Robust Location and Covariance Estimator, \emph{Statistics and Computing}, 22(1), 325-336, DOI: 10.1007/s11222-011-9250-3.

Liebscher, S., Kirschstein, T., and Becker, C. (2013): RDELA - A Delaunay-Triangulation-based, Location and Covariance Estimator with High Breakdown Point, \emph{Statistics and Computing}, DOI: 10.1007/s11222-012-9337-5.
}

\keyword{ robust }
