/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.UUID;
import java.util.function.Supplier;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;

public class SupplierUtil {
    public static final Supplier<DefaultEdge> DEFAULT_EDGE_SUPPLIER = SupplierUtil.createSupplier(DefaultEdge.class);
    public static final Supplier<DefaultWeightedEdge> DEFAULT_WEIGHTED_EDGE_SUPPLIER = SupplierUtil.createSupplier(DefaultWeightedEdge.class);
    public static final Supplier<Object> OBJECT_SUPPLIER = SupplierUtil.createSupplier(Object.class);

    public static <T> Supplier<T> createSupplier(Class<? extends T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
                constructor.setAccessible(true);
            }
            return new ConstructorSupplier<T>(constructor);
        }
        catch (ReflectiveOperationException e) {
            String error = e.getMessage();
            return new AlwaysFailingSupplier(error);
        }
    }

    public static Supplier<DefaultEdge> createDefaultEdgeSupplier() {
        return SupplierUtil.createSupplier(DefaultEdge.class);
    }

    public static Supplier<DefaultWeightedEdge> createDefaultWeightedEdgeSupplier() {
        return SupplierUtil.createSupplier(DefaultWeightedEdge.class);
    }

    public static Supplier<Integer> createIntegerSupplier() {
        return new IntegerSupplier(0);
    }

    public static Supplier<Integer> createIntegerSupplier(int start) {
        return new IntegerSupplier(start);
    }

    public static Supplier<Long> createLongSupplier() {
        return new LongSupplier(0L);
    }

    public static Supplier<Long> createLongSupplier(long start) {
        return new LongSupplier(start);
    }

    public static Supplier<String> createStringSupplier() {
        return new StringSupplier(0);
    }

    public static Supplier<String> createRandomUUIDStringSupplier() {
        return new RandomUUIDStringSupplier();
    }

    public static Supplier<String> createStringSupplier(int start) {
        return new StringSupplier(start);
    }

    private static class AlwaysFailingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = -560480634880773413L;
        private String error;

        public AlwaysFailingSupplier() {
        }

        public AlwaysFailingSupplier(String error) {
            this.error = error;
        }

        @Override
        public T get() {
            throw new RuntimeException(this.error);
        }
    }

    private static class ConstructorSupplier<T>
    implements Supplier<T>,
    Serializable {
        private final Constructor<? extends T> constructor;

        public ConstructorSupplier(Constructor<? extends T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T get() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Supplier failed", ex);
            }
        }

        Object writeReplace() throws ObjectStreamException {
            return new SerializedForm<T>(this.constructor.getDeclaringClass());
        }

        private static class SerializedForm<T>
        implements Serializable {
            private static final long serialVersionUID = -2385289829144892760L;
            private final Class<T> type;

            public SerializedForm(Class<T> type) {
                this.type = type;
            }

            Object readResolve() throws ObjectStreamException {
                try {
                    return new ConstructorSupplier<T>(this.type.getDeclaredConstructor(new Class[0]));
                }
                catch (ReflectiveOperationException e) {
                    InvalidObjectException ex = new InvalidObjectException("Failed to get no-args constructor from " + this.type);
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
    }

    private static class RandomUUIDStringSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = -4636552536822031851L;

        private RandomUUIDStringSupplier() {
        }

        @Override
        public String get() {
            return UUID.randomUUID().toString();
        }
    }

    private static class StringSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = -5025488316341437260L;
        private int i = 0;

        public StringSupplier(int start) {
            this.i = start;
        }

        @Override
        public String get() {
            return String.valueOf(this.i++);
        }
    }

    private static class LongSupplier
    implements Supplier<Long>,
    Serializable {
        private static final long serialVersionUID = 4994477932143967277L;
        private long i = 0L;

        public LongSupplier(long start) {
            this.i = start;
        }

        @Override
        public Long get() {
            return this.i++;
        }
    }

    private static class IntegerSupplier
    implements Supplier<Integer>,
    Serializable {
        private static final long serialVersionUID = -4714266728630636497L;
        private int i = 0;

        public IntegerSupplier(int start) {
            this.i = start;
        }

        @Override
        public Integer get() {
            return this.i++;
        }
    }
}

